﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CashierCrisis.Behaviors
{
    public class Selector : Composite
    {
        private int childIndex = 0;

        public override Status Execute(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (Children.Count == 0 || childIndex >= Children.Count)
                return Failed;

            Behavior behavior = Children[childIndex];

            Status status = behavior.Execute(gameTime);

            switch (status)
            {
                case Status.Completed:
                    return Completed;
                case Status.Failed:
                    childIndex++;
                    return Running;
                case Status.Running:
                    return Running;
            }

            return base.Execute(gameTime);
        }
    }
}
